from openai import OpenAI
import json

client = OpenAI()
def chat_completion(prompt, model="gpt-4", temperature=0, response_format=None):
    res = client.chat.completions.create(
        model=model,
        messages=[{"role": "user", "content": prompt}],
        temperature=temperature,
        response_format=response_format 
    )
    return(res.choices[0].message.content)




def the_reviewer(prompt_initialization, current_prompt):
    
    prompt_reviewer = prompt_initialization + "\n\n"
    prompt_reviewer += f"To jest mój prompt: {current_prompt}\n\n"
    prompt_reviewer += """Zadanie: Przedstaw szczegółową, rygorystyczną ocenę mojego promptu.
    Aby to zrobić, najpierw oceń mój prompt w skali od 0 do 5 (0 dla słabego, 5 dla bardzo optymalnego), a następnie napisz krótki akapit, w którym przedstawisz ulepszenia, które uczyniłyby mój prompt idealnym z oceną 5."""
    
    reviews= chat_completion(prompt_reviewer)

    print(reviews)
    
    return reviews


def the_questioner(prompt_initialization, current_prompt, reviews, questions_answers):
        
        prompt_questioner = prompt_initialization + "\n\n"
        prompt_questioner += f"To jest mój prompt: {current_prompt}\n\n"
        prompt_questioner += f"Krytyczna recenzja mojego promptu:{reviews}\n\n"
        prompt_questioner += """Zadanie: Sporządź listę maksymalnie 4 najważniejszych pytań, których odpowiedzi są niezbędne do ulepszenia mojego promptu (podaj również przykłady odpowiedzi w nawiasach). Format wyjściowy: W formacie JSON. Wynik musi być akceptowalny przez json.loads. Format JSON powinien wyglądać tak.: {'Pytania': ['Pytanie 1','Pytanie 2','Pytanie 3','Pytanie 4']}"""
        
        questions_json = chat_completion(prompt_questioner, model="gpt-4-1106-preview", response_format={"type": "json_object"})

        try:
            questions = json.loads(questions_json).get('Pytania', [])
        except json.JSONDecodeError:
            print("Nie udało się zdekodować pytań z odpowiedzi modelu.")
            questions = []
        
        for i, question in enumerate(questions, start=1):
            answer = input(f"Pytanie {i}: {question} ")
            questions_answers = questions_answers + f"Pytanie: {question}\nOdpowiedź:{answer}\n\n"
        
        return questions_answers


def the_prompt_maker(prompt_initialization, current_prompt, reviews, questions_answers):
     
    prompt =  prompt_initialization + "\n\n"
    prompt += f"To jest mój bieżący prompt: {current_prompt}\n\n"
    prompt += f"To jest krytyczna recenzja mojego bieżącego promptu:{reviews}\n\n"
    prompt += f"Kilka pytań i odpowiedzi dotyczących ulepszenia mojego bieżącego promptu:{questions_answers}\n\n"
    prompt += """Zadanie: Korzystając z całej tej wiedzy, użyj swojej wiedzy z zakresu inżynierii promptów, aby przeredagować mój bieżący prompt w najlepszy możliwy sposób, tworząc idealny prompt dla GPT z oceną 5. 
    Cała treść zawarta w pytaniach i odpowiedziach musi być uwzględniona w nowym prompcie. 
    Zacznij prompt, przypisując GPT jedną lub więcej ról, definiując kontekst oraz zadanie. 
    Wynik: Ważne jest, abyś zwrócił tylko nowy prompt dla GPT, które stworzyłeś, i nic więcej."""

    new_prompt = chat_completion(prompt)
    return(new_prompt)

def promptor(initial_prompt, max_nb_iter=3):

    print(f"Twój początkowy prompt: {initial_prompt}")

    prompt_initialization = """Jesteś ekspertem w dziedzinie projektowania promptów i dużych modeli językowych. 
    Dobry prompt powinien przypisywać GPT jedną lub wiele ról, definiować wyraźny kontekst i zadanie oraz precyzować oczekiwany rezultat.
    Znasz i używasz wielu technik promptów, takich jak: Few-Shot Learning, Prompt Chaining, Shadow Prompting, ...
    Chcę, abyś był moim osobistym ekspertem twórcy promptów.
    Twoje imię to teraz 'Promptor' i tak będę cię od teraz nazywać.
    Promptor i GPT to oddzielne i odrębne jednostki.
    Ty, Promptorze, jesteś odpowiedzialny za tworzenie dobrych promptów dla GPT."""
    
    current_prompt = initial_prompt
    questions_answers = ""
    for i in range(max_nb_iter):

        print(f"Pętla {i+1}")
        reviews = the_reviewer(prompt_initialization, current_prompt)
        questions_answers = the_questioner(prompt_initialization, current_prompt, reviews, questions_answers)
        current_prompt = the_prompt_maker(prompt_initialization, current_prompt, reviews, questions_answers)
        
        print(f"\nNowy bieżący prompt: {current_prompt}\n\n")
        keep = input(f"Czy chcesz zachować ten prompt (y/n)? ")
        if keep == 'y':
            break

    return current_prompt


prompt = promptor("Zaproponuj mi coś na dzisiejszy obiad",  max_nb_iter=3)
res = chat_completion(prompt)
print(res)
